﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIASchedulingService.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.CancelAppointment
{
    public class SerializeEcRequestStep : FilterBase<CancelAppointmentStateObject>
    {
        public override void Execute(CancelAppointmentStateObject state)
        {
            var patRequest = state.PatEcRequest != null ? PipelineUtilities.SerializeInstance(state.PatEcRequest) : "No Patient Side EC Request";
            var proRequest = state.ProEcRequest != null ? PipelineUtilities.SerializeInstance(state.ProEcRequest) : "No Provider Side EC Request";
            state.SerializedCancelRequest = string.Format(Strings.SerializedEcRequest, patRequest, proRequest);
        }

    }
}
